/*    Foundation Window/Control Resource Editor Module  */
/*    Common Routines                                   */
#pragma noroot
#include <foundation.h>
#include <event.h>

void GetTitleStrings(void)
{
word 			i, j;
char 			*c;
handle			theLoad;


	theLoad = GetResData(rStringList, 1, 1);
    c = (char *) *theLoad;
	c = &c[2];
    for (j = 0; j < 32; j++) {
	rDesString[j] = (char *) &c[1];
        c += c[0] + 1;
    }
}

void GetIcons(void)
{
	ArrowIcon[0] = (QDIconRecordPtr) deref(GetResData(rIcon, 1, 1);
	ArrowIcon[1] = (QDIconRecordPtr) deref(GetResData(rIcon, 2, 1);
}

void SetWorkingData(GrafPortPtr winP, word Task)
{
	if (task) {     /* we want to get our data */
		PrivPB.pCount = 4;
		PrivPB.winPtr = winP;
		PrivPB.TaskMask = 0L;
		PrivPB.remSignature = 0;
		PrivPB.Data = (Handle) private;
		fGetPrivateData(&PrivPB);
		pPtr = deref(private);
		edWin = deref(pPtr->edTempH);
		wkWin = deref(pPtr->wkTempH);
	}
	else			/* we want to put away our toys for now */
		PrivPB.pCount = 4;
		PrivPB.winPtr = winP;
		PrivPB.TaskMask = 0L;
		PrivPB.remSignature = 0;
		PrivPB.Data = (Handle) private;
		fSetPrivateData(&PrivPB);
		HUnlock(pPtr->edTempH);
		HUnlock(pPtr->wkTempH);
		HUnlock(private);
	}
}

void ReleaseRes(word type , long ID)
{
fResRefRec		thePB;

	thePB.pCount = 2;
	thePB.resType = type;
	thePB.resID = ID;
	bad = fReleaseResource(&thePB);
}

Handle RevertResData(word rType, long rID, Handle resData);
{
Handle			wblk;

	wblk = (Handle) GetResData(rType, rID, locked);
	DisposeHandle(resData);
	return wblk;
}

Handle UpdateResData(word rType, long rID, Handle resData, word locked);
}
Handle			sblk, wblk;
long			hansize;

	hansize = GetHandleSize(resData);
	HLock(resData);
	wblk = NewHandle(hansize, edUserID, 0x8018, 0L);
	HandToHand(resData, wblk, hansize);
	RefPB.pCount = 2;
	RefPB.resType = rType;
	RefPB.resID = rID;
	fRemoveResource(&RefPB);
	DataPB.pCount = 3;
	DataPB.resType = rType;
	DataPB.resID = rID;
	DataPB.resData = wblk;
	fAddResource(&DataPB);
	ReleaseRes(rType, rID)
	if (!locked)
		HUnlock(wblk);
	return resData;
}

void SetWindMenu (word enable, GrafPortPtr winP)
{
word			i;
CtlRecHndl		menuBarH;

	menuBarH = GetMenuBar();
	SetMenuBar(GetCtlHandleFromID(winP, 0x500L));
	for (i = 0x50A; i < 0x511; i++)
		{
		if (enable)
			EnableMItem(i);
		else
			DisableMItem(i);
		}
}

long GetResData(word rType, long rID, word locked);
}
Handle			sblk, wblk;
long			hansize;
fResDataRec		loadPB;
fResRefRec		dumpPB;

	loadPB.pCount = 4;
	dumpPB.pCount = 2;
	loadPB.resType = dumpPB.resType = rType;
	loadPB.resID = dumpPB.resID = rID;
	bad = fLoadResource(&loadPB);
	if (!bad)
	{
		if (loadPB.special == -1)
		{
			fDetachResource(&dumpPB);
			wblk = loadPB.resData;
			fReleaseResource(&dumpPB);
		}
		else
		{
			hansize = GetHandleSize(loadPB.resData);
			wblk = NewHandle(hansize, edUserID, 0x8018, 0L);
			HandToHand(loadPB.resData, wblk, hansize);
		}
	if (locked)
		HLock(wblk);
	else
		HUnlock(wblk);
	return (long) wblk;
}

long GetListRef(long rID, word lCount, word lSize);
{
Handle			sblk, wblk, transblk;
multiPtr		eptr, wptr;
word			i;
long			hansize;

	sblk = GetResData (rType, rID, 0);
	hansize = GetHandleSize(sblk);
	wblk = NewHandle(hansize, edUserID, 0x8018, 0L);
	HandToHand(sblk, wblk, hansize);
	eptr.Ptr = deref (sblk);
	wptr.Ptr = deref (wblk);
	for (i = 0; i < lCount; i++, ePtr.Ptr += lSize, wptr.Ptr += lSize)
	{
		transblk = (Handle) GetResData(rPString, *eptr.lptr, 1);
		*wptr.lptr = *transblk;
	}
	ReleaseRes(rType, rID)
	return (long) *wblk;
}

long GetItemStruct(long rID);
{
Handle				eblk, wblk;
MenuTemplatePtr		eptr, wptr;
long				hansize;

	eblk = (Handle) GetResData(rItemStruct, rID, 1);
	hansize = GetHandleSize(eblk);
	wblk = NewHandle(hansize, edUserID, 0x8018, 0L);
	HandToHand(eblk, wblk, hansize);
	eptr = (itemStructPtr) deref(eblk);
	wptr = (itemStructPtr) deref(wblk);
	wptr->itemFlag2 &= 0x7ffc;
	wptr->itemIconRef = GetResData(rIcon, eptr->itemIconRef, 1);
	if (wptr->itemIconRef)
		wptr->itemFlag2 |= 0x8001;
	wptr->itemTitleRef = GetResData(rPString, eptr->itemTitleRef, 1);
	if (wptr->itemTitleRef)
		temp = 1;
	ReleaseRes(rMenuItem, rID);
	return (long) wblk;
}

long GetMenuItem(long rID);
{
Handle				eblk, wblk;
MenuTemplatePtr		eptr, wptr;
long				hansize;

	eblk = (Handle) GetResData(rMenuItem, rID, 1);
	hansize = GetHandleSize(eblk);
	wblk = NewHandle(hansize, edUserID, 0x8018, 0L);
	HandToHand(eblk, wblk, hansize);
	eptr = (MenuItemTemplatePtr) deref(eblk);
	wptr = (MenuItemTemplatePtr) deref(wblk);
	temp = 0;
	wptr->itemFlag &= 0x3cff;
	if (eptr->itemFlag & 0x0400) /* we have an item struct here */
		{
		wptr->itemFlag |= 0x0100;
		wptr->itemTitleRef = GetItemStruct(eptr->itemTitleRef);
		if (temp)
			wptr->itemFlag |= 0x4000;
        }
 	else					/* if not, we have a PString here */
		wptr->itemTitleRef = GetResData(rPString, eptr->itemTitleRef, 1);
	if (wptr->itemTitleRef)
		wptr->itemFlag |= 0x4000;
	ReleaseRes(rMenuItem, rID);
	return (long) wblk;
}

long GetMenu(long rID);
{
Handle				eblk, wblk;
MenuTemplatePtr		eptr, wptr;
long				hansize;

	eblk = (Handle) GetResData(rMenu, rID, 1);
	hansize = GetHandleSize(eblk);
	wblk = NewHandle(hansize, edUserID, 0x8018, 0L);
	HandToHand(eblk, wblk, hansize);
	eptr = (MenuTemplatePtr) deref(eblk);
	wptr = (MenuTemplatePtr) deref(wblk);
	wptr->menuFlag &= 0x0fff;
	wptr->menuTitleRef = GetResData(rPString, eptr->menuTitleRef, 1);
	if (wptr->menuTitleRef)
		wptr->menuFlag |= 0x4000;
	for (i = 0; eptr->itemRefArray[i] != 0L; i++)
		wptr->itemRefArray[i] GetMenuItem(eptr->itemRefArray[i]);
	if (wptr->itemRefArray[0])
		wptr->menuFlag |= 0x1000;
	ReleaseRes(rMenu, rID);
	return (long) wblk;
}

long GetColorTbl(long rID, word dep);
{
Handle              eblk, wblk;
TEColorTablePtr     eptr, wptr;
long                hansize;

	eblk = (Handle) GetResData(rColorTable, rID, 0);
	hansize = GetHandleSize(eblk);
	wblk = NewHandle(hansize, edUserID, 0x8018, 0L);
	HandToHand(eblk, wblk, hansize);
	if (dep)			/* if true, it's a TE Block */
	{
		eptr = (TEColorTablePtr) deref(eblk);
		wptr = (TEColorTablePtr) deref(wblk);
		wptr->vertColorRef = GetResData(rColorTable, eptr->vertColorRef, 0);
		if (wptr->vertColorRef)
		{
			wptr->vertColorDescriptor = 4;
			ReleaseRes(rColorTable, eptr->vertColorRef)
		}
		else
			wptr->vertColorDescriptor = 0;
		wptr->horzColorRef = GetResData(rColorTable, eptr->horzColorRef, 0);
		if (wptr->horzColorRef)
		{
			wptr->horzColorDescriptor = 4;
			ReleaseRes(rColorTable, eptr->horzColorRef)
        }
		else
			wptr->horzColorDescriptor = 0;
		wptr->growColorRef = GetResData(rColorTable, eptr->growColorRef, 0);
		if (wptr->growColorRef)
		{
			wptr->growColorDescriptor = 4;
			ReleaseRes(rColorTable, eptr->growColorRef)
		}
		else
			wptr->growColorDescriptor = 0;
	}
	ReleaseRes(rColorTable, rID);
	HUnlock(wblk);
	return (long) wblk;
}

long GetWkCtl (long rID)
{
long				procRef, hansize, wkID, edID;
word				pCount, i, ctlMore;
Handle				edCtl, wkCtl;
control				wkControl, edControl;

	edCtl = GetResData(rControlTemplate, rID, 0);
	hansize = GetHandleSize(edCtl);
	wkCtl = NewHandle(hansize, edUserID, 0x8018, 0L);
	HandToHand(pPtr->edCtl, wkCtl, hansize);
	edControl.dummy = deref(edCtl);
	wkControl.dummy = deref(wkCtl);
	procRef = edControl.BcPtr->ctlTemplate.procRef;
	switch (procRef)
	{
		case simpleButtonControl:
			{
			ctlMore = edControl.BcPtr->ctlTemplate.moreFlags;
			ctlMore &= 0xfff0;
			wkControl.BcPtr->titleRef = GetResData(rPString, edControl.BcPtr->titleRef), 0);
			if (wkControl.BcPtr->titleRef)
				ctlMore |= 0x0001;
			wkControl.BcPtr->colorTableRef = GetColorTbl(edControl.BcPtr->colorTableRef, 0);
			if (wkControl.BcPtr->colorTableRef)
				ctlMore |= 0x0004;
			wkControl.BcPtr->ctlTemplate.moreFlags = ctlMore;
			break;
			}
		case checkControl:
			{
			ctlMore = edControl.CBcPtr->ctlTemplate.moreFlags;
			ctlMore &= 0xfff0;
			wkControl.CBcPtr->titleRef = GetResData(rPString, edControl.CBcPtr->titleRef, 0);
			if (wkControl.CBcPtr->titleRef)
				ctlMore |= 0x0001;
			wkControl.CBcPtr->colorTableRef = GetColorTbl(edControl.CBcPtr->colorTableRef, 0);
			if (wkControl.CBcPtr->colorTableRef)
				ctlMore |= 0x0004;
			wkControl.CBcPtr->ctlTemplate.moreFlags = ctlMore;
			break;
            }
		case iconButtonControl:
		case 0x07ff0001:
			{
			ctlMore = edControl.CBcPtr->ctlTemplate.moreFlags;
			ctlMore &= 0xffc0;
			wkControl.IcPtr->iconRef = GetResData(rIcon, edControl.IcPtr->iconRef, 0);
			if (wkControl.IcPtr->iconRef)
				ctlMore |= 0x0010;
			wkControl.IcPtr->titleRef = GetResData(rPString, edControl.IcPtr->titleRef, 0);
			if (wkControl.IcPtr->titleRef)
				ctlMore |= 0x0001;
			wkControl.IcPtr->colorTableRef = GetColorTbl(edControl.IcPtr->colorTableRef, 0);
			if (wkControl.IcPtr->colorTableRef)
				ctlMore |= 0x0004;
			wkControl.IcPtr->ctlTemplate.moreFlags = ctlMore;
			break;
			}
		case editLineControl:
			{
			ctlMore = edControl.LEcPtr->ctlTemplate.moreFlags;
			ctlMore &= 0xffFc;
			wkControl.LEcPtr->defaultRef = GetResData(rPString,
					edControl.LEcPtr->defaultRef, 0);
			if (wkControl.LEcPtr->defaultRef)
				ctlMore |= 0x0001;
			wkControl.LEcPtr->ctlTemplate.moreFlags = ctlMore;
			break;
			}
		case listControl:
			{
			ctlMore = edControl.LcPtr->ctlTemplate.moreFlags;
			ctlMore &= 0xffF0;
			wkControl.LcPtr->listRef = GetListRef(edControl.LcPtr->listRef,
					edControl.LcPtr->listSize, edControl.LcPtr->listMemSize);
			if (wkControl.LcPtr->listRef)
				ctlMore |= 0x0000;   /* we use a pointer here!  SHEESH!  */
			wkControl.LcPtr->colorTableRef = GetColorTbl(edControl.LcPtr->colorTableRef, 0);
			if (wkControl.LcPtr->colorTableRef)
				ctlMore |= 0x0004;
			wkControl.LcPtr->ctlTemplate.moreFlags = ctlMore;
			break;
            }
		case pictureControl:
			{
			ctlMore = edControl.PcPtr->ctlTemplate.moreFlags;
			ctlMore &= 0xffF0;
			wkControl.PcPtr->pictureRef = GetResData(rPicture, edControl.PcPtr->pictureRef, 0);
			if (wkControl.PcPtr->pictureRef)
				ctlMore |= 0x0001;
			wkControl.PcPtr->ctlTemplate.moreFlags = ctlMore;
			break;
		case popUpControl:
			{
			ctlMore = edControl.PMcPtr->ctlTemplate.moreFlags;
			ctlMore &= 0xffe0;
			wkControl.PMcPtr->menuRef = GetMenu(edControl.PMcPtr->menuRef);
			if (wkControl.PMcPtr->menuRef)
				ctlMore |= 0x0001;
			wkControl.PMcPtr->colorTableRef = GetMenu(edControl.PMcPtr->colorTableRef);
			if (wkControl.PMcPtr->colorTableRef)
				ctlMore |= 0x0008;
			wkControl.PMcPtr->ctlTemplate.moreFlags = ctlMore;
			break;
			}
		case radioControl:
			{
			ctlMore = edControl.CBcPtr->ctlTemplate.moreFlags;
			ctlMore &= 0xfff0;
			wkControl.CBcPtr->titleRef = GetResData(rPString, edControl.CBcPtr->titleRef, 0);
			if (wkControl.CBcPtr->titleRef)
				ctlMore |= 0x0001;
			wkControl.CBcPtr->colorTableRef = GetColorTbl(edControl.CBcPtr->colorTableRef, 0);
			if (wkControl.CBcPtr->colorTableRef)
				ctlMore |= 0x0004;
			wkControl.CBcPtr->ctlTemplate.moreFlags = ctlMore;
			break;
			}
		case scrollBarControl:
			{
			ctlMore = edControl.SBcPtr->ctlTemplate.moreFlags;
			ctlMore &= 0xfff3;
			wkControl.SBcPtr->colorTableRef = GetColorTbl(edControl.SBcPtr->colorTableRef, 0);
			if (wkControl.SBcPtr->colorTableRef)
				ctlMore |= 0x0004;
			wkControl.SBcPtr->ctlTemplate.moreFlags = ctlMore;
			break;
			}
		case growControl:
			{
			ctlMore = edControl.GcPtr->ctlTemplate.moreFlags;
			ctlMore &= 0xfff3;
			wkControl.GcPtr->colorTableRef = GetColorTbl(edControl.GcPtr->colorTableRef, 0);
			if (wkControl.GcPtr->colorTableRef)
				ctlMore |= 0x0004;
			wkControl.GcPtr->ctlTemplate.moreFlags = ctlMore;
			break;
			}
		case statTextControl:
			{
			ctlMore = edControl.BcPtr->ctlTemplate.moreFlags;
			ctlMore &= 0xfffc;
			wkControl.BcPtr->titleRef = GetResData(rTextForLETextBox2, edControl.BcPtr->titleRef, 0);
			if (wkControl.BcPtr->titleRef)
				ctlMore |= 0x0001;
			wkControl.BcPtr->ctlTemplate.moreFlags = ctlMore;
			break;
			}
		case editTextControl:
			{
			ctlMore = edControl.TEcPtr->ctlTemplate.moreFlags;
			ctlMore &= 0xfff0;
			wkControl.TEcPtr->styleRef = GetResData(rStyleBlock, edControl.TEcPtr->styleRef, 0);
			if (wkControl.TEcPtr->styleRef)
				ctlMore |= 0x0001;
			wkControl.TEcPtr->ColorTableRef = GetColorTbl(edControl.TEcPtr->colorTableRef, 1);
            if (wkControl.TEcPtr->colorTableRef)
				ctlMore |= 0x0004;
			i = wkControl.TEcPtr->textDescriptor & 0x0007;
			wkControl.TEcPtr->textDescriptor &= 0xffe7;
			wkControl.TEcPtr->textRef = GetResData(TEType[i], edControl.TEcPtr->textRef, 0);
			if (wkControl.TEcPtr->textRef)
				wkControl.TEcPtr->textDescriptor |= 0x0008;
			wkControl.TEcPtr->ctlTemplate.moreFlags = ctlMore;
			break;
			}
		case rectangleControl:
			{
			break;
			}
		case thermometerControl:
			{
			ctlMore = edControl.TcPtr->ctlTemplate.moreFlags;
			ctlMore &= 0xfffc;
			wkControl.TcPtr->ColorTableRef = GetColorTbl(edControl.TcPtr->colorTableRef, 0);
			if (wkControl.TcPtr->colorTableRef)
				ctlMore |= 0x0001;
			wkControl.TcPtr->ctlTemplate.moreFlags = ctlMore;
			break;
			}
	}
	HUnlock(edCtl);
	ReleaseRes(rControlTemplate, rID)
	HUnlock(wkCtl);
	return (long) wkCtl;
}

long GetWkMenuBar (long rID)
{
word			i;
long			hansize, wkID, edID, *wkPtr, *edPtr;

	pPtr->edMenuBarH = GetResData(rMenuBar, rID, 1);
	hansize = GetHandleSize(pPtr->edMenuBarH);
	pPtr->wkMenuBarH = NewHandle(hansize, edUserID, 0x8018, 0L);
	HandToHand(pPtr->edMenuBarH, pPtr->wkMenuBarH, hansize);
	edPtr = deref(pPtr->edMenuBarH);
	wkPtr = deref(pPtr->wkMenuBarH);
	*wkPtr = 0x0001;
	for (i = 0; edPtr[i + 1] != 0L; i++)
	{
		edID = edPtr[i + 1];
		wkID = GetMenu(edID);
		wkPtr[i + 1] = wkID;
	}
	HUnlock(pPtr->edMenuBarH);
	HUnlock(pPtr->wkMenuBarH);
	return (long) pPtr->wkMenuBarH;
}

long GetWkCtlList (long rID)
{
long			hansize;
long			*wkPtr;
long			*edPtr;
long			wkID;
long			edID;
word			i;

	pPtr->edCtlListH = GetResData(rControlList, rID, 0);
	hansize = GetHandleSize(pPtr->edCtlListH);
	pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	HandToHand(pPtr->edCtlListH, pPtr->wkCtlListH, hansize);
	edPtr = deref(pPtr->edCtlListH);
	wkPtr = deref(pPtr->wkCtlListH);
	for (i = 0; edPtr[i] != 0L; i++)
	{
		edID = edPtr[i];
		wkID = GetWkCtl(edID);
		wkPtr[i] = wkID;
	}
	HUnlock(pPtr->edCtlListH);
	HUnlock(pPtr->wkCtlListH);
	return (long) pPtr->wkCtlListH;
}

/*--------------------------------------
	GetMasterColors extracts the current settings for a control or window color
	table and places them for manipulation into our master color array.  It also
	stores a copy in the private data for the particular control editor window
	for use later.  Notice that we are somewhat forcing the users hand to make
	sure such tacky details like Text Background and Item Background are
	not in conflict with each other.  Bye Bye, DesignBlaster!!
	LineEdit, Picture, StatText, Rectangle do not utilize Color Templates

	Mark T. Collins    							3/6/92  	3:44PM
	brought up to date and made more universal	4/25/92  	3:08AM
*/

void GetMasterColors(word kind)
{
	theColors.dummy = deref(pPtr->data);
	switch (kind) {
		case 0:
		case 1: {
			pPtr->MasterColor[0] =  getNibble(theColors->WinCol.frameColor, 1);
			pPtr->MasterColor[1] =  getNibble(theColors->WinCol.titleColor, 0);
			pPtr->MasterColor[2] =  getNibble(theColors->WinCol.tBarColor, 0);
			pPtr->MasterColor[3] =  getNibble(theColors->WinCol.tBarColor, 1);
			pPtr->MasterColor[4] =  getNibble(theColors->WinCol.titleColor, 2);
			pPtr->MasterColor[5] =  getNibble(theColors->WinCol.titleColor, 1);
			pPtr->MasterColor[6] =  getNibble(theColors->WinCol.growColor, 1);
			pPtr->MasterColor[7] =  getNibble(theColors->WinCol.growColor, 0);
			pPtr->MasterColor[8] =  getNibble(theColors->WinCol.infoColor, 1);
			pPtr->MasterColor[9] =  getNibble(theColors->WinCol.growColor, 3);
			pPtr->MasterColor[A] =  getNibble(theColors->WinCol.infoColor, 3);
			break;
		}
		case 2:
		case 3: {
			pPtr->MasterColor[0] =  getNibble(theColors->BoCol.boxNor, 0);
			pPtr->MasterColor[1] =  getNibble(theColors->BoCol.boxNor, 1);
			pPtr->MasterColor[2] =  getNibble(theColors->BoCol.boxTitle, 0);
			pPtr->MasterColor[3] =  getNibble(theColors->BoCol.boxSel,0);
			pPtr->MasterColor[4] =  getNibble(theColors->BoCol.boxSel, 1);
			pPtr->MasterColor[5] =  getNibble(theColors->BoCol.boxTitle, 1);
			pPtr->MasterColor[6] =  getNibble(theColors->BoCol.boxTitle, 0);
			pPtr->MasterColor[7] =  getNibble(theColors->BoCol.boxNor, 1);
			break;
		}
		case 4:
		case 5:{
			pPtr->MasterColor[0] =  getNibble(theColors->BuCol.bttnOutline, 1);
			pPtr->MasterColor[1] =  getNibble(theColors->BuCol.bttnNorBack, 1);
			pPtr->MasterColor[2] =  getNibble(theColors->BuCol.bttnNorText, 0);
			pPtr->MasterColor[3] =  getNibble(theColors->BuCol.bttnSelText, 0);
			pPtr->MasterColor[4] =  getNibble(theColors->BuCol.bttnSelBack, 1);
			pPtr->MasterColor[5] =  getNibble(theColors->BuCol.bttnSelBack, 1);
			pPtr->MasterColor[6] =  getNibble(theColors->BuCol.bttnNorText, 0);
			pPtr->MasterColor[7] =  getNibble(theColors->BuCol.bttnNorBack, 1);
			break;
		}
		case 6: {
			pPtr->MasterColor[0] =  getNibble(theColors->LiCol.listFrameClr, 0);
			pPtr->MasterColor[1] =  getNibble(theColors->LiCol.listNorBackClr, 0);
			pPtr->MasterColor[2] =  getNibble(theColors->LiCol.listNorTextClr, 0);
			pPtr->MasterColor[3] =  getNibble(theColors->LiCol.listSelTextClr, 0);
			pPtr->MasterColor[4] =  getNibble(theColors->LiCol.listSelBackClr, 0);
			pPtr->MasterColor[5] =  getNibble(theColors->LiCol.listNorBackClr, 0);
			pPtr->MasterColor[6] =  getNibble(theColors->LiCol.listNorTextClr, 0);
			pPtr->MasterColor[7] =  getNibble(theColors->LiCol.listNorBackClr, 0);
			break;
		}
		case 7: {
			pPtr->MasterColor[0] =  getNibble(theColors->MeCol.Outline, 0);
			pPtr->MasterColor[1] =  getNibble(theColors->MeCol.NorText, 1);
			pPtr->MasterColor[2] =  getNibble(theColors->MeCol.NorText, 0);
			pPtr->MasterColor[3] =  getNibble(theColors->MeCol.HiText, 0);
			pPtr->MasterColor[4] =  getNibble(theColors->MeCol.HiText, 1);
			pPtr->MasterColor[5] =  getNibble(theColors->MeCol.NorText, 1);
			pPtr->MasterColor[6] =  getNibble(theColors->MeCol.NorText, 0);
			pPtr->MasterColor[7] =  getNibble(theColors->MeCol.NorText, 1);
			break;
		}
		case 8: {
			pPtr->MasterColor[0] =  getNibble(theColors->ScCol.barOutline, 1);
			pPtr->MasterColor[1] =  getNibble(theColors->ScCol.barArrowBack, 1);
			pPtr->MasterColor[2] =  getNibble(theColors->ScCol.barNorArrow, 0);
			pPtr->MasterColor[3] =  getNibble(theColors->ScCol.barSelArrow, 0);
			pPtr->MasterColor[4] =  getNibble(theColors->ScCol.barSelArrow, 1);
			pPtr->MasterColor[5] =  getNibble(theColors->ScCol.barNorArrow, 1);
			pPtr->MasterColor[6] =  getNibble(theColors->ScCol.barPageRgn, 0);
			pPtr->MasterColor[7] =  getNibble(theColors->ScCol.barPageRgn, 1);
			break;
		}
		case 9: {
			pPtr->MasterColor[0] =  getNibble(theColors->SiCol.Outline, 1);
			pPtr->MasterColor[1] =  getNibble(theColors->SiCol.NorBack, 1);
			pPtr->MasterColor[2] =  getNibble(theColors->SiCol.NorBack, 0);
			pPtr->MasterColor[3] =  getNibble(theColors->SiCol.NorBack, 0);
			pPtr->MasterColor[4] =  getNibble(theColors->SiCol.NorBack, 1);
			pPtr->MasterColor[5] =  getNibble(theColors->SiCol.NorBack, 1);
			pPtr->MasterColor[6] =  getNibble(theColors->SiCol.NorBack, 0);
			pPtr->MasterColor[7] =  getNibble(theColors->SiCol.NorBack, 1);
			break;
		}
		case 10: {
			pPtr->MasterColor[0] =  getNibble(theColors->TECol.outlineColor, 0);
			pPtr->MasterColor[1] =  getNibble(theColors->TECol.contentColor, 0);
			pPtr->MasterColor[2] =  getNibble(theColors->TECol.outlineColor, 0);
			pPtr->MasterColor[3] =  getNibble(theColors->TECol.contentColor, 0);
			pPtr->MasterColor[4] =  getNibble(theColors->TECol.outlineColor, 0);
			pPtr->MasterColor[5] =  getNibble(theColors->TECol.outlineColor, 0);
			pPtr->MasterColor[6] =  getNibble(theColors->TECol.outlineColor, 0);
			pPtr->MasterColor[7] =  getNibble(theColors->TECol.contentColor, 0);
			break;
		}
		case 11: {
			pPtr->MasterColor[0] =  theColors->ThCol.Outline, 0);
			pPtr->MasterColor[1] =  theColors->ThCol.Content, 0);
			pPtr->MasterColor[2] =  theColors->ThCol.Outline, 0);
			pPtr->MasterColor[3] =  theColors->ThCol.Content, 0);
			pPtr->MasterColor[4] =  theColors->ThCol.Outline, 0);
			pPtr->MasterColor[5] =  theColors->ThCol.Outline, 0);
			pPtr->MasterColor[6] =  theColors->ThCol.Outline, 0);
			pPtr->MasterColor[7] =  theColors->ThCol.Content, 0);
			break;
		}
	}
}

/*--------------------------------------
	SetMasterColors replaces the current settings for a control or window color
	table from our master color array.

	Mark T. Collins    3/8/92 10:24AM
*/

void SetMasterColors(long ctlType)
{
word	patkind;

    theColors.dummy = deref(pPtr->data);
    switch (pPtr->parentKind) {
		case 0:
		case 1: {
			theColors->WinCol.frameColor = buildWord(0,0,pPtr->MasterColor[0],0);
			theColors->WinCol.titleColor = buildWord(0,pPtr->MasterColor[4],
					pPtr->MasterColor[5], pPtr->MasterColor[1]);
			patkind = GetCtlValue(GetCtlHandleFromID(winP, 0x300L)) - 1;
			theColors->WinCol.tBarColor = buildWord(0, patkind,
					pPtr->MasterColor[3], pPtr->MasterColor[2]);
			theColors->WinCol.growColor = buildWord( pPtr->MasterColor[9], 0,
					pPtr->MasterColor[6], pPtr->MasterColor[7]);
			theColors->WinCol.infoColor = buildWord(pPtr->MasterColor[10],0,
					pPtr->MasterColor[8], 0);
			break;
		}
		case 2:
		case 3: {
			theColors->BoCol.boxReserved = 0;
			theColors->BoCol.boxNor = buildWord(0, 0, pPtr->MasterColor[1],
					pPtr->MasterColor[0]);
			theColors->BoCol.boxNor = buildWord(0,0, pPtr->MasterColor[1],
					pPtr->MasterColor[0]);
			theColors->BoCol.boxSel = buildWord(0,0, pPtr->MasterColor[4],
					pPtr->MasterColor[3]);
			theColors->BoCol.boxTitle = buildWord(0,0, pPtr->MasterColor[5],
					pPtr->MasterColor[2]);
			break;
		}
		case 4:
		case 5: {
			theColors->BuCol.bttnOutline = buildWord(0, 0, pPtr->MasterColor[0], 0);
			theColors->BuCol.bttnNorBack = buildWord(0, 0, pPtr->MasterColor[2], 0);
			theColors->BuCol.bttnSelBack = buildWord(0, 0, pPtr->MasterColor[4], 0);
			theColors->BuCol.bttnNorText = buildWord(0, 0, pPtr->MasterColor[1],
					pPtr->MasterColor[2]);
			theColors->BuCol.bttnSelText = buildWord(0, 0, pPtr->MasterColor[4],
					pPtr->MasterColor[3]);
			break;
		}
		case 6: {
			theColors->LiCol.listFrameClr = pPtr->MasterColor[0];
			theColors->LiCol.listNorTextClr = pPtr->MasterColor[2];
			theColors->LiCol.listSelTextClr = pPtr->MasterColor[3];
			theColors->LiCol.listNorBackClr = pPtr->MasterColor[1];
			theColors->LiCol.listSelBackClr = pPtr->MasterColor[4];
			break;
        }
		case 7: {
			theColors->MeCol.NorText = buildWord(0, 0, pPtr->MasterColor[1],
					pPtr->MasterColor[2]);
			theColors->MeCol.HiText = buildWord(0, 0, pPtr->MasterColor[4],
					pPtr->MasterColor[3]);
			theColors->MeCol.Outline = pPtr->MasterColor[0];
			break;
		}
		case 8: {
			theColors->ScCol.barOutline = buildWord(0,0, pPtr->MasterColor[0],0);
			theColors->ScCol.barNorArrow = buildWord(0,0, pPtr->MasterColor[5],
					pPtr->MasterColor[2]);
			theColors->ScCol.barSelArrow = buildWord(0,0, pPtr->MasterColor[4],
					pPtr->MasterColor[3]);
			theColors->ScCol.barArrowBack = buildWord(0,0, pPtr->MasterColor[1],0);
			theColors->ScCol.barNorThumb = buildWord(0,0, pPtr->MasterColor[5], 0);
			theColors->ScCol.barSelThumb = 0;
			theColors->ScCol.barPageRgn = buildWord(0,0, pPtr->MasterColor[7],
					pPtr->MasterColor[6]);
			theColors->ScCol.barInactive = buildWord(0,0, pPtr->MasterColor[1], 0);
			if (pPtr->MasterColor[6] != pPtr->MasterColor[7])
				theColors->ScCol.barPageRgn &= 0x8000;
			break;
		}
		case 9:
			theColors->SiCol.Outline = buildWord(0,0, pPtr->MasterColor[0],0);
            theColors->SiCol.NorBack = pPtr->MasterColor[2] & (pPtr->MasterColor[1] << 4);
            break;
		}
		case 10: {
			theColors->TECol.contentColor = pPtr->MasterColor[1];
			theColors->TECol.outlineColor = pPtr->MasterColor[0];
			theColors->TECol.hiliteForeColor = 0;
			theColors->TECol.hiliteBackColor = 0;
			break;
		}
		case 11: {
			theColors->ThCol.Outline = pPtr->MasterColor[0];
			theColors->ThCol.Interior = pPtr->MasterColor[1];
			theColors->ThCol.Foregnd = pPtr->MasterColor[3];
			theColors->ThCol.Backgnd = pPtr->MasterColor[4];
			if theColors->ThCol.Foregnd != theColors->ThCol.Backgnd
				theColors->ThCol.Backgnd &= 0x8000;
			break;
		}
	}
}

/*--------------------------------------
	DrawClrCtls paints and frames the color rects for use as our pseudo-
	controls in the color editors, and draws their titles.  It should be
	called by the drawProc for this editor's windows.  We don't differentiate
	between 320 & 640 modes, since in 320 mode we simply use the same values-
	on a double width window, just as the rest of the system does.

	Mark T. Collins    					3/9/92  12:26PM
	revised & made more universal		4/25/92  3:59AM
*/

void DrawClrCtls (word curType)
{
word			i;

	for (i = 0; i < Slave[curType].numColors; i++)
		PaintClrRect (Slave[curType].cRect[i], Slave[curType].color[i]);
	GetPenPat(oldPenPat);
	SetSolidPenPat(0);
	for (i = 0; i < Slave[curType].numStrings; i++) {
		MoveTo(StringLoc[Slave[curType].stringLoc[i]]);
        DrawCString(rDesString[Slave[curType].rString[i]]);
        }
	SetPenPat(oldPenPat);
}

/*--------------------------------------
	PaintColorRect is called to set the color of one of our pseudo color
	controls.  If the rect is single, only Rec1 and Col1 have appropriate
	values, and Rec2 and Col2 should contain 0.
	If the rect is a dual (foreground/background), this MUST be called in
	pairs so that both rects get drawn properly, with the foreground on top
	and the background beneath it.

	Mark T. Collins    4/8/92  4:21PM
*/

void PaintClrRect (word Rec1, word Col1)
{
word			vMode;
Point			oldPenSize;
PatternPtr		oldPenPat;


	vMode = (GetMasterSCB() & 0x80) ? 0, 1; /* 0 = 640 */
	GetPenPat(oldPenPat);
	GetPenSize(oldPenSize);
	SetPenSize(ourPen[vMode]);
	SetSolidPenPat(Col1);
	PaintRect(ColorRect[Rec1]);
	SetSolidPenPat(0);
	FrameRect(ColorRect[Rec1]);
	SetPenSize(oldPenSize);
	SetPenPat(oldPenPat);
}

/* the snippets provided below require substantial work */

/*--------------------------------------
	CheckColorChange is called upon a MouseDown event in the Control Color
	editor.  It first determines if the hit was in one of the appropriate
	Color Boxes- if so, it dispatches to fSelectColor to allow the user to
	change color.  If not, it simply returns with nothing done.

	Mark T. Collins    3/9/92  12:57PM
*/

void CheckColorChange (pointPtr thePoint);
{
word			i, j, curType;

	curType = pPtr->shortKind;
	j = Slave[curType].numColors;
	for (i = j; i >= 0; i--) {
		if PointInRect(thePoint, ColorRect[Slave[curType].cRect[i]) {
			p.pCount = 2;
			p.point = thePoint;
			p.color = pPtr->MasterColor[i];
			fSelectColor(&p);
			pPtr->MasterColor[Slave[curType].color[i]] = p.color;
			DrawCtlColors();
			break;
		}
	}
}

void HandleSpecialButtons (word theID)  /* this should be the control ID hit */
{
long    newID;

    switch (theID) {
        case vertScrollBar:
        case horzScrollBar: {
            newID = CtlColorEdBackDoor(6);  /* this needs some fleshing out */
                                            /* after we BUILD our front and */
                                            /* back doors! The 6 stands for */
                                            /* our Short Kind (Scroll Bar */
            break;
        }
        case sizeBox: {
            newID = CtlColorEdBackDoor(6);
            break;
        }
    }
}
